clear all;close all;clc;

%% Fig. 4
N = 64;
K = 8;
L = 2;
alpha = 4;
M1 = [1:30];
PO_Mine1 = (N+1)*L/alpha+K*ceil((N+M1)./M1);
PO_MVU1 = N*K*M1./M1;
PO_MU1 = K + N + max(K-1,ceil((K-1)*N./M1));
M2 = [1,5:5:30];
PO_Mine2 = (N+1)*L/alpha+K*ceil((N+M2)./M2);
PO_MVU2 = N*K*M2./M2;
PO_MU2 = K + N + max(K-1,ceil((K-1)*N./M2));
M3 = [1];
PO_Mine3 = (N+1)*L/alpha+K*ceil((N+M3)./M3);
PO_MVU3 = N*K*M3./M3;
PO_MU3 = K + N + max(K-1,ceil((K-1)*N./M3));

figure;
plot(M3,PO_Mine3,'r-v','LineWidth',1.5);
hold on;
p=plot(M3,PO_MVU3,'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(M3,PO_MU3,'b-d','LineWidth',1.5);
hold on;
plot(M1,PO_Mine1,'r-','LineWidth',1.5);
hold on;
p=plot(M1,PO_MVU1,'g-','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(M1,PO_MU1,'b-','LineWidth',1.5);
hold on;
plot(M2,PO_Mine2,'rv','LineWidth',1.5);
hold on;
p=plot(M2,PO_MVU2,'go','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(M2,PO_MU2,'bd','LineWidth',1.5);

grid on;
h=xlabel('number of BS antennas','fontname','Arial');
h=ylabel('pilot overhead','fontname','Arial');
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 5
M = 32;
K = 8;
L = 2;
alpha = 4;
N1 = [16:8:64];
PO_Mine1 = (N1+1)*L/alpha+K*ceil((N1+M)/M);
PO_MVU1 = N1*K*M/M;
PO_MU1 = K + N1 + max(K-1,ceil((K-1)*N1/M));
N2 = [16:8:64];
PO_Mine2 = (N2+1)*L/alpha+K*ceil((N2+M)/M);
PO_MVU2 = N2*K*M/M;
PO_MU2 = K + N2 + max(K-1,ceil((K-1)*N2/M));
N3 = [16];
PO_Mine3 = (N3+1)*L/alpha+K*ceil((N3+M)/M);
PO_MVU3 = N3*K*M/M;
PO_MU3 = K + N3 + max(K-1,ceil((K-1)*N3/M));

figure;
plot(N3,PO_Mine3,'r-v','LineWidth',1.5);
hold on;
p=plot(N3,PO_MVU3,'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(N3,PO_MU3,'b-d','LineWidth',1.5);
hold on;
plot(N1,PO_Mine1,'r-','LineWidth',1.5);
hold on;
p=plot(N1,PO_MVU1,'g-','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(N1,PO_MU1,'b-','LineWidth',1.5);
hold on;
plot(N2,PO_Mine2,'rv','LineWidth',1.5);
hold on;
p=plot(N2,PO_MVU2,'go','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(N2,PO_MU2,'bd','LineWidth',1.5);

grid on;
h=xlabel('number of RIS elements','fontname','Arial');
h=ylabel('pilot overhead','fontname','Arial');
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 6
M = 32;
N = 64;
L = 2;
alpha = 4;
K1 = [2:8];
PO_Mine1 = (N+1)*L/alpha+K1*ceil((N+M)/M);
PO_MVU1 = N*K1*M/M;
PO_MU1 = K1 + N + max(K1-1,ceil((K1-1)*N/M));
K2 = [2:8];
PO_Mine2 = (N+1)*L/alpha+K2*ceil((N+M)/M);
PO_MVU2 = N*K2*M/M;
PO_MU2 = K2 + N + max(K2-1,ceil((K2-1)*N/M));
K3 = [2];
PO_Mine3 = (N+1)*L/alpha+K3*ceil((N+M)/M);
PO_MVU3 = N*K3*M/M;
PO_MU3 = K3 + N + max(K3-1,ceil((K3-1)*N/M));

figure;
plot(K3,PO_Mine3,'r-v','LineWidth',1.5);
hold on;
p=plot(K3,PO_MVU3,'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(K3,PO_MU3,'b-d','LineWidth',1.5);
hold on;
plot(K1,PO_Mine1,'r-','LineWidth',1.5);
hold on;
p=plot(K1,PO_MVU1,'g-','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(K1,PO_MU1,'b-','LineWidth',1.5);
hold on;
plot(K2,PO_Mine2,'rv','LineWidth',1.5);
hold on;
p=plot(K2,PO_MVU2,'go','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(K2,PO_MU2,'bd','LineWidth',1.5);

grid on;
h=xlabel('number of UEs','fontname','Arial');
h=ylabel('pilot overhead','fontname','Arial');
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 7
clear all;
load fig7.mat
figure;
semilogy(I_list,Mean_Convergence_0dB,'b-x','LineWidth',1.5,'markersize',10);
hold on;
semilogy(I_list,Mean_Convergence_10dB,'r-o','LineWidth',1.5);
hold on;
p=semilogy(I_list,Mean_Convergence_20dB,'r-^','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);
hold on;
errorbar(I_list,Mean_Convergence_0dB,min(STD_Convergence_0dB,Mean_Convergence_0dB-1e-6),'b-','LineWidth',1.5);
hold on;
errorbar(I_list,Mean_Convergence_10dB,min(STD_Convergence_10dB,Mean_Convergence_10dB-1e-6),'r-','LineWidth',1.5);
hold on;
p=errorbar(I_list,Mean_Convergence_20dB,min(STD_Convergence_20dB,Mean_Convergence_20dB-1e-6),'r-','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);
ylim([0.001,100]);
grid on;
h=xlabel('index of outer iteration','fontname','Arial');
h=ylabel('normalized value of the objective function','fontname','Arial');
legend('SINR_{\it{L}} = 0 dB','SINR_{\it{L}} = 10 dB','SINR_{\it{L}} = 20 dB');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 8
clear all;
figure;
load fig8_9.mat
plot(SNR_S_list,10*log10(NMSE_c_mine),'r-v','LineWidth',1.5);
hold on;
p=plot(SNR_S_list,10*log10(NMSE_c_MVU),'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(SNR_S_list,10*log10(NMSE_c_MU),'b-d','LineWidth',1.5);
hold on;
p=plot(SNR_S_list,10*log10(NMSE_c_CS),'b-^','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);
grid on;
xlabel('SNR_{\it{S}} (dB)','fontname','Arial');
ylabel('NMSE of the cascaded channel (dB)','fontname','Arial');
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]','CS-based channel estimation [17]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');
ylim([-60,40]);


%% Fig. 9
figure;
plot(SNR_S_list,10*log10(NMSE_d_mine),'r-v','LineWidth',1.5);
hold on;
p=plot(SNR_S_list,10*log10(NMSE_d_MVU),'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(SNR_S_list,10*log10(NMSE_d_MU),'b-d','LineWidth',1.5);
grid on;
xlabel('SNR_{\it{S}} (dB)','fontname','Arial');
ylabel('NMSE of the direct channel (dB)','fontname','Arial');
xlim([-5-1e-6 30]);
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 10
clear all;
load fig10.mat
figure;
plot(SNR_S_list,mean(SR_mine,2),'r-v','LineWidth',1.5);
hold on;
p=plot(SNR_S_list,mean(SR_MVU,2),'g-o','LineWidth',1.5);
set(p,'Color',[0 0.7 0]);
hold on;
plot(SNR_S_list,mean(SR_MU,2),'b-d','LineWidth',1.5);
hold on;
p=semilogy(SNR_S_list,mean(SR_CS,2),'b-^','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);
grid on;
xlabel('SNR_{\it{S}} (dB)','fontname','Arial');
ylabel('sum rate (bit/s/Hz)','fontname','Arial');
legend('Proposed two-timescale channel estimation','MVU estimator [5]','Multi-user channel estimation [14]','CS-based channel estimation [17]');
set(gcf,'position',[200,200,520,390]);
set(gca,'fontname','Arial');


%% Fig. 11
clear all;
load fig11.mat

figure;
plot(L_list,10*log10(mean(squeeze(SE_H_c_mine(1,:,:)),2)/mean(Norm_H_c)),'r-v','LineWidth',1.5);
hold on;
plot(L_list,10*log10(mean(squeeze(SE_H_c_Baseline(1,:,:)),2)/mean(Norm_H_c))*ones(numel(L_list),1),'b-d','LineWidth',1.5);
hold on;
plot(L_list,10*log10(mean(squeeze(SE_H_c_mine(2,:,:)),2)/mean(Norm_H_c)),'r-v','LineWidth',1.5);
hold on;
plot(L_list,10*log10(mean(squeeze(SE_H_c_Baseline(2,:,:)),2)/mean(Norm_H_c))*ones(numel(L_list),1),'b-d','LineWidth',1.5);
hold on;
plot(L_list,10*log10(mean(squeeze(SE_H_c_mine(3,:,:)),2)/mean(Norm_H_c)),'r-v','LineWidth',1.5);
hold on;
plot(L_list,10*log10(mean(squeeze(SE_H_c_Baseline(3,:,:)),2)/mean(Norm_H_c))*ones(numel(L_list),1),'b-d','LineWidth',1.5);
grid on;
xlabel('L');
ylabel('NMSE (dB)');
legend('Estimated{\bf G}','Perfect{\bf G} (baseline)');